﻿
local me = { name = "taunt"}
local mod = thismod
mod[me.name] = me

--[[
Taunt.lua

Handles the Taunt class of spells: Warrior's Taunt, Druid's Growl, Paladin's Righteous Defense.

To debug this module, uncomment this code:

me.mytraces = 
{
	default = "info",
}

]]


--[[
mod.taint.taunt(target, spellid)

Called by CombatParser.lua when one of the taunt abilities are fired. These are "Taunt" or "Growl" (bear) or "Righteous Defense". The corresponding values of <spellid> are "taunt", "growl", "righteousdefense".
<target> is the name of the mob that was taunted.
]]
me.taunt = function(target, spellid)
	
	-- debugging
	if mod.trace.check("info", me, "findmt") then
		mod.trace.printf("Taunting %s with %s.", target, spellid)
	end
	
	-- ignore taunts on non-master targets
	if mod.target.targetismaster(target) == nil then
		return
	end
	
	-- check for unique previous target
	local tank = mod.tank.getsingletarget(target)
	
	if tank then
		
		-- debugging
		if mod.trace.check("info", me, "findmt") then
			mod.trace.printf("found the unique target %s of %s", tank, target)
		end
		
		me.tauntfrommt(tank, spellid)
		return
	end
	
	-- otherwise: no unique target. Try to sort out multiple targets
	if mod.tank.recentattacks[target] then
		
		local topthreat = 0
		local toptarget = ""
		local player, threat, mytargettarget
		
		-- if our target matches the taunted mob, then get the targettarget from it. Accept this player as the tank if they are in the recent attacks data.
		if UnitName("target") == target then
			mytargettarget = UnitName("targettarget")
		end
				
		for player, _ in pairs(mod.tank.recentattacks[target]) do
			
			if player == mytargettarget then
				
				if mod.trace.check("info", me, "findmt") then
					mod.trace.printf("%s is our targettarget and has been attacked by %s, so is a suitable tank candidate.", player, target)
				end
				
				me.tauntfrommt(player, spellid)
				return
				
			elseif mod.table.raiddata[player] and mod.table.raiddata[player] > topthreat then
				topthreat = mod.table.raiddata[player]
				toptarget = player
			end
		end
		
		-- taunt from player with top threat if we have one
		if topthreat > 0 then
			
			if mod.trace.check("info", me, "findmt") then
				mod.trace.printft("identified %s as the highest threat player of the taunted mob %s.", toptarget, target)
			end
			
			me.tauntfrommt(toptarget, spellid)
			return
		end
		
	end
		
	-- mob has made no recent autoattacks, or we couldn't identify a target from them. We can only use targettarget.
	me.tauntfrommt(UnitName("targettarget"), spellid)
	return

end

--[[
After discovering the original target of the mob in <me.taunt>, call <me.tauntfrommt>. The value <tank> is not guaranteed to be good; it might not be a player, might not exist, or might be from a player who doesn't have KTM.

<tank>		name of the player we thing originally had aggro
<spellid>	id of the spell used to taunt the mob.
]]
me.tauntfrommt = function(tank, spellid)
	
	-- debugging
	if mod.trace.check("info", me, "process") then
		mod.trace.printf("attempting to gain the threat of player %s.", tank or "nil")
	end
	
	-- 1) try to identify <tank>
	if tank == nil or mod.table.raiddata[tank] == nil then
		
		if mod.trace.check("info", me, "process") then
			mod.trace.print("Could not calculate the threat of the previous tank.")
		end
	
		return
	end
	
	-- 2) Ignore if less threat than us, or the same as us
	if mod.table.raiddata[tank] <= mod.table.getraidthreat() then
		
		if mod.trace.check("info", me, "process") then
			mod.trace.print("The tank has less than or equal to our own threat; ignoring.")
		end
		
		return
	end
		
	-- 3) Perform threat gain
	local threatgain = mod.table.raiddata[tank] - mod.table.getraidthreat()
	
	if mod.trace.check("info", me, "process") then
		mod.trace.printf("Gaining %d threat from taunt.", threatgain)
	end
	
	mod.combat.lognormalevent(mod.string.get("spell", spellid), 1, 0, threatgain)
	
end